//------------------------------------------------------------------------------
//! @file FreqCalc_SX126x.h
//! @ingroup Utils
//! <!------------------------------------------------------------------------->
//! @brief Helper Utility to calc frequency to transceiver register and vice versa for the SX126x transceiver series
//! @version 0.1
//! <!------------------------------------------------------------------------->
//!
//!
//!
//! <!--------------------------------------------------------------------------
//! Copyright (c) 2022
//! IMST GmbH
//! Carl-Friedrich Gauss Str. 2-4
//! 47475 Kamp-Lintfort
//! --------------------------------------------------------------------------->
//! @author (FB), IMST
//! <!--------------------------------------------------------------------------
//! Target OS:    none
//! Target CPU:   tbd
//! Compiler:     tbd
//! --------------------------------------------------------------------------->
//! @internal
//! @par Revision History:
//! <PRE>
//!-----------------------------------------------------------------------------
//! Version | Date       | Author | Comment
//!-----------------------------------------------------------------------------
//!
//! </PRE>
//------------------------------------------------------------------------------


#ifndef ARDUINO_UTILS_FREQCALC_SX126x_H_
#define ARDUINO_UTILS_FREQCALC_SX126x_H_

//------------------------------------------------------------------------------
//
// Section Includes Files
//
//------------------------------------------------------------------------------


#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

void     FreqCalcSX126x_calcFreqToRegister(uint32_t freq, uint8_t* msb, uint8_t* mid, uint8_t* lsb);
uint32_t FreqCalcSX126x_calcRegisterToFreq(uint8_t msb, uint8_t mid, uint8_t lsb);

#ifdef __cplusplus
}
#endif




#endif /* ARDUINO_UTILS_FREQCALC_SX126x_H_ */
