//------------------------------------------------------------------------------
//! @file WiMOD_SAP_RadioLink_ProLink.h
//! @ingroup WiMOD_SAP_RadioLink_PROLINK
//! <!------------------------------------------------------------------------->
//! @brief Declarations for the RadioLink SericeAccessPoint
//! @version 0.1
//! <!------------------------------------------------------------------------->
//!
//!
//!
//! <!--------------------------------------------------------------------------
//! Copyright (c) 2022
//! IMST GmbH
//! Carl-Friedrich Gauss Str. 2-4
//! 47475 Kamp-Lintfort
//! --------------------------------------------------------------------------->
//! @author (FB), IMST
//! <!--------------------------------------------------------------------------
//! Target OS:    none
//! Target CPU:   tbd
//! Compiler:     tbd
//! --------------------------------------------------------------------------->
//! @internal
//! @par Revision History:
//! <PRE>
//!-----------------------------------------------------------------------------
//! Version | Date       | Author | Comment
//!-----------------------------------------------------------------------------
//!
//! </PRE>
//------------------------------------------------------------------------------


/*
 * THIS IS AN EXAMPLE IMPLEMENTATION ACCORDING THE THE HCI SPEC: V1.3
 * FOR FIRMWARE: LoRaWAN PROLINK
 *
 * SEE FILE: ProLink_LoRaWAN_EndNode_Modem_HCI_Spec_v1_3.pdf for detailed information
 */



#ifndef ARDUINO_SAP_WIMOD_SAP_RADIOLINK_PROLINK_H_
#define ARDUINO_SAP_WIMOD_SAP_RADIOLINK_PROLINK_H_

//------------------------------------------------------------------------------
//
// Section Includes Files
//
//------------------------------------------------------------------------------

#include "WiMOD_SAP_RadioLink_ProLink_IDs.h"
#include "WiMOD_SAP_RadioLink.h"

//------------------------------------------------------------------------------
//
// Section class
//
//------------------------------------------------------------------------------


/**
 * @brief Implementation for the ServiceAccessPoint RadioLink (LR-Base firmware only)
 */
class WiMOD_SAP_RadioLink_ProLink : public WiMOD_SAP_RadioLink {
public:
    WiMOD_SAP_RadioLink_ProLink(TWiMODLRHCI* hci, UINT8* buffer, UINT16 bufferSize);
    virtual ~WiMOD_SAP_RadioLink_ProLink(void);

    /* currently not supported */
    virtual TWiMODLRResultCodes SendCData(const TWiMODLR_RadioLink_Msg* txMsg, UINT8* statusRsp);
    virtual bool convert(TWiMODLR_HCIMessage& RxMsg, TWiMODLR_RadioLink_CdataInd* cDataTxInfo);
    virtual bool convert(TWiMODLR_HCIMessage& RxMsg, TWiMODLR_AckTxInd_Msg* txAckIndInfo);

    virtual bool convert(TWiMODLR_HCIMessage& RxMsg, TWiMODLR_RadioLink_Msg* radioLinkMsg)     { return WiMOD_SAP_RadioLink::convert(RxMsg, radioLinkMsg); };
    virtual bool convert(TWiMODLR_HCIMessage& RxMsg, TWiMODLR_RadioLink_UdataInd* uDataTxInfo) { return WiMOD_SAP_RadioLink::convert(RxMsg, uDataTxInfo);  };

    virtual TWiMODLRResultCodes SetAckData(const TWiMODLR_RadioLink_Msg* txMsg, UINT8* statusRsp);


   /* currently not supported */
//   virtual void RegisterRawDataRxClient(TRadioLinkRawDataRxIndicationCallback cb);
//   virtual void RegisterCDataRxClient(TRadioLinkCDataRxIndicationCallback cb);
//   virtual void RegisterCDataTxClient(TRadioLinkCDataTxIndicationCallback cb);
//   virtual void RegisterAckRxClient(TRadioLinkAckRxIndicationCallback cb);
//   virtual void RegisterAckRxTimeoutClient(TRadioLinkAckRxTimeoutIndicationCallback cb);
//   virtual void RegisterAckTxCallback(TRadioLinkAckTxIndicationCallback cb);

    virtual TWiMODLRResultCodes SetAesKey(const UINT8* key, UINT8* statusRsp);
    virtual TWiMODLRResultCodes GetAesKey(UINT8* key, UINT8* statusRsp);

    virtual TWiMODLRResultCodes GetRadioConfig(TWiMODLR_ProLinkRadioLink_RadioConfig* radioCfg, UINT8* statusRsp);
    virtual TWiMODLRResultCodes SetRadioConfig(const TWiMODLR_ProLinkRadioLink_RadioConfig* radioCfg, UINT8* statusRsp);
    virtual TWiMODLRResultCodes ResetRadioConfig(UINT8* statusRsp);

    virtual void DispatchRadioLinkProLinkMessage(TWiMODLR_HCIMessage& rxMsg);

protected:
    virtual TWiMODLRResultCodes unsupportedCmd(UINT8* statusRsp);

};


#endif /* ARDUINO_SAP_WIMOD_SAP_RADIOLINK_PROLINK_H_ */
