//------------------------------------------------------------------------------
//! @file WiMOD_SAP_LORAWAN_ProLink_IDs.h
//! @ingroup WiMOD_SAP_LORAWAN_PROLINK
//! <!------------------------------------------------------------------------->
//! @brief Supporting IDs and definitions for the LoRaWAN ServiceAccessPoint for the ProLink firmware
//! @version 0.1
//! <!------------------------------------------------------------------------->
//!
//!
//!
//! <!--------------------------------------------------------------------------
//! Copyright (c) 2022
//! IMST GmbH
//! Carl-Friedrich Gauss Str. 2-4
//! 47475 Kamp-Lintfort
//! --------------------------------------------------------------------------->
//! @author (FB), IMST
//! <!--------------------------------------------------------------------------
//! Target OS:    none
//! Target CPU:   tbd
//! Compiler:     tbd
//! --------------------------------------------------------------------------->
//! @internal
//! @par Revision History:
//! <PRE>
//!-----------------------------------------------------------------------------
//! Version | Date       | Author | Comment
//!-----------------------------------------------------------------------------
//!
//! </PRE>
//------------------------------------------------------------------------------


/*
 * THIS IS AN EXAMPLE IMPLEMENTATION ACCORDING THE THE HCI SPEC: V2.0
 * FOR FIRMWARE: ProLink_
 *
 * SEE FILE: ProLink_LoRaWAN_EndNode_Modem_HCI_Spec.pdf (version 2.0)
 * for detailed information
 *
 */


#ifndef ARDUINO_SAP_WIMOD_SAP_LORAWAN_PROLINK_IDS_H_
#define ARDUINO_SAP_WIMOD_SAP_LORAWAN_PROLINK_IDS_H_

#include "utils/WMDefs.h"

#include "WiMOD_SAP_LORAWAN_IDs.h"

#include "WiMOD_SAP_LORAWAN_IDs_EU868.h"  /* Europe       */
#include "WiMOD_SAP_LORAWAN_IDs_RU868.h"  /* Russia       */
#include "WiMOD_SAP_LORAWAN_IDs_IN865.h"  /* India        */
#include "WiMOD_SAP_LORAWAN_IDs_AS923.h"  /* Asia/Pacific */
#include "WiMOD_SAP_LORAWAN_IDs_IL915.h"  /* Israel       */
#include "WiMOD_SAP_LORAWAN_IDs_US915.h"  /* US           */
#include "WIMOD_SAP_LORAWAN_IDs_AU915.h"  /* Australia    */

/**
 * @brief Channel Band Selection
 */

typedef enum TProLinkLoRaWAN_FreqBand
{
    ProLink_LoRaWAN_FreqBand_EU_868            = LORAWAN_BAND_EU_868,                   /*!< EU 868 MHz band */

    ProLink_LoRaWAN_FreqBand_IN_865            = LORAWAN_BAND_IN_865,                   /*!< India */

    ProLink_LoRaWAN_FreqBand_US_915            = LORAWAN_BAND_US_915,                   /*!< US 915 MHz band */

    ProLink_LoRaWAN_FreqBand_AU_915            = LORAWAN_BAND_AU_915,                   /*!< UA 915 MHz band */

    ProLink_LoRaWAN_FreqBand_AS_923_1          = LORAWAN_BAND_AS_923_1,                   /*!< AS 923 MHz band */
    ProLink_LoRaWAN_FreqBand_AS_923_2          = LORAWAN_BAND_AS_923_2,                   /*!< AS 923 MHz band */
    ProLink_LoRaWAN_FreqBand_AS_923_3          = LORAWAN_BAND_AS_923_3,                   /*!< AS 923 MHz band */

    ProLink_LoRaWAN_FreqBand_RU_868            = LORAWAN_BAND_EU_868,                   /*!< RU 868 MHz band */


    ProLink_LoRaWAN_FreqBand_EU_868_RX2_SF9    = LORAWAN_BAND_EU_868_RX2_SF9,           /*!< alternative EU band, using SF9 for 2nd RX window */
    ProLink_LoRaWAN_FreqBand_IN_865_RX2_SF8    = LORAWAN_BAND_IN_865_RX2_SF8,           /*!< alternative IN band, using SF8 for 2nd RX window */

    ProLink_LoRaWAN_FreqBand_WW2G4             = GLOBALLINK24_BAND_WW_2G4,              /*!< proprietary extension for emulating LoRaWAN on 2.4 GHz */
    ProLink_LoRaWAN_FreqBand_WW2G4_RX2         = GLOBALLINK24_BAND_WW_2G4_RX2,          /*!< proprietary extension for emulating LoRaWAN on 2.4 GHz with RX2 window using 2.422 GHz */
} TProLinkLoRaWAN_FreqBand;


/**
 * @brief Structure containing all data necessary to transmitting a data message
 */
typedef struct TWiMODProLinkLORAWAN_TX_Data
{
    UINT8       Port;                                                           /*!< target LoRaWAN port number */
    UINT8       Length;                                                         /*!< Length of the payload data */
    UINT8       Payload[WiMODLORAWAN_APP_PAYLOAD_LEN];                          /*!< (user) payload */
    // only for RX
    UINT32      ChannelBlockTime;                                               /*!< DutyCyle block time*/
} TWiMODProLinkLORAWAN_TX_Data;


/**
 * @brief info data structure for LoRa device time request MAC command
 */
typedef struct TWiMODLORAWAN_DevTimeReqInfo
{
//    UINT8       Status;
    UINT32      ChannelBlockTime;                                               /*!< Time (ms) remaining till channel available */
} TWiMODLORAWAN_DevTimeReqInfo;


/**
 * @brief info data structure for LoRa device time request MAC command
 */
typedef struct TWiMODLORAWAN_DevTimeAnsInfo
{
    UINT8       Status;
    UINT32      GpsTime;                                                        /*!< GPS epoch time from LNS */
} TWiMODLORAWAN_DevTimeAnsInfo;


typedef struct TWiMODLORAWAN_McastConfig
{
    UINT8       MulticastIndex;
    UINT32      DeviceAddress;                                                  /*!< address of the WiMOD within the Multicast context of LoRaWAN network */

    /* only for GET-Operations */
    UINT8       MulticastStatus;                                                /*!< Status of Multicast Mode; 1 = active */

    /* only for SET-Operations */
    UINT8       NwkSKey[WiMODLORAWAN_NWK_SESSION_KEY_LEN];                      /*!< secret network session key (128bit) for Multicast context */
    UINT8       AppSKey[WiMODLORAWAN_APP_SESSION_KEY_LEN];                      /*!< secret application session key (128bit) for Multicast context */
} TWiMODLORAWAN_McastConfig;



/**
 * @brief Structure containing a MultiCast Data
 */
typedef struct TWiMODLORAWAN_McastData
{
    // only for RX
    UINT8       StatusFormat;                                                   /*!< Status/Format Field set by WiMOD;  */

    UINT32      DeviceAddress;                                                  /*!< address of the WiMOD within the Multicast context of LoRaWAN network */

    UINT8       LoRaWANPort;                                                    /*!< The port number on which the data has been received */

    UINT8       AppPayload[WiMODLORAWAN_APP_PAYLOAD_LEN];                       /*!< The application layer payload */;
    UINT8       Length;

    // optional - see StatusFormat code
    UINT8       ChannelIndex;                                                   /*!< used channel index (@see TLoRaWAN_Channel_* definitions)*/
    UINT8       DataRateIndex;                                                  /*!< used data rate index (@see TLoRaWANDataRate*)  */
    INT8        RSSI;                                                           /*!< RSSI value for the received packet */
    INT8        SNR;                                                            /*!< SNR value for the received packet  */
    UINT8       RxSlot;                                                         /*!< number of the rx slot that contained the message */
    bool        OptionalInfoAvaiable;                                           /*!< are the optional value fields available */


} TWiMODLORAWAN_McastData;


/* bit fields for Multicast error indications */
#define PROLINK_MCAST_ERR_WRONG_MTYPE           (1 << 0)
#define PROLINK_MCAST_ERR_WRONG_DEV_ADR         (1 << 1)
#define PROLINK_MCAST_ERR_WRONG_MIC             (1 << 2)
#define PROLINK_MCAST_ERR_UNEXPTECTED_FCNT      (1 << 3)
#define PROLINK_MCAST_ERR_RX_MAC_CMD            (1 << 4)
#define PROLINK_MCAST_ERR_WRONG_DOWNLINK        (1 << 5)
#define PROLINK_MCAST_ERR_MCAST_DOWNLINK_ERR    (1 << 6)


/**
 * @brief Structure containing a MultiCast Data
 */
typedef struct TWiMODLORAWAN_McastNoData
{
    // only for RX
    UINT8       StatusFormat;                                                   /*!< Status/Format Field set by WiMOD;  */

    UINT8       ErrorCode;                                                      /*!< ErrorCode bit field  @see PROLINK_MCAST_ERR_* defines*/

    UINT32      DeviceAddress;                                                  /*!< address of the WiMOD within the Multicast context of LoRaWAN network */

} TWiMODLORAWAN_McastNoData;


/**
 * @brief Radio stack configuration related to to LoRaWAN specific options.
 */
typedef struct TWiMODProLinkLORAWAN_RadioStackConfig
{
    UINT8       DataRateIndex;                                                  /*!< data rate to use (@see TLoRaWANDataRate*) */
    UINT8       TXPowerLevel;                                                   /*!< default / initial power level settings to be used */
    UINT8       Options;                                                        /*!< misc Options (see LORAWAN_STK_OPTION defines) */

    UINT8       Retransmissions;                                                /*!< max number of retransmissions (for C-Data) to use */
    UINT8       BandIndex;                                                      /*!< Frequency band to use (@see TLoRaWAN_FreqBand) */
    UINT8       HeaderMacCmdCapacity;                                           /*!< Header MAC Cmd Capatity (size in Byte) */

    // US915/AU915 Firmware only
    UINT8       SubBandMask1;                                                   /*!< Sub-band selection for 125 kHz bandwidth channels */
    UINT8       SubBandMask2;                                                   /*!< Sub-band selection for 500 kHz bandwidth channels */

    // optional for SetRadioStack cmd
    UINT8       WrongParamErrCode;                                              /*!< error code in case of a wrong parameter (@see LORAWAN_STK_PARAM_ERR defines)  */

} TWiMODProLinkLORAWAN_RadioStackConfig;



#endif /* ARDUINO_SAP_WIMOD_SAP_LORAWAN_PROLINK_IDS_H_ */
