//------------------------------------------------------------------------------
//! @file WiMOD_SAP_DEVMGMT_ProLink_IDs.h
//! @ingroup WiMOD_SAP_DEVMGMT_PROLINK
//! <!------------------------------------------------------------------------->
//! @brief Supporting IDs and definitions for the DeviceManagement ServiceAccessPoint for LoRaWAN ProLink firmware
//! @version 0.1
//! <!------------------------------------------------------------------------->
//!
//!
//!
//! <!--------------------------------------------------------------------------
//! Copyright (c) 2022
//! IMST GmbH
//! Carl-Friedrich Gauss Str. 2-4
//! 47475 Kamp-Lintfort
//! --------------------------------------------------------------------------->
//! @author (FB), IMST
//! <!--------------------------------------------------------------------------
//! Target OS:    none
//! Target CPU:   tbd
//! Compiler:     tbd
//! --------------------------------------------------------------------------->
//! @internal
//! @par Revision History:
//! <PRE>
//!-----------------------------------------------------------------------------
//! Version | Date       | Author | Comment
//!-----------------------------------------------------------------------------
//!
//! </PRE>
//------------------------------------------------------------------------------


/*
 * THIS IS AN EXAMPLE IMPLEMENTATION ACCORDING THE THE HCI SPEC: V1.3
 * FOR FIRMWARE: LoRaWAN PROLINK
 *
 * SEE FILE: ProLink_LoRaWAN_EndNode_Modem_HCI_Spec_v1_3.pdf for detailed information
 */


#ifndef ARDUINO_SAP_WIMOD_SAP_DEVMGMT_PROLINK_IDS_H_
#define ARDUINO_SAP_WIMOD_SAP_DEVMGMT_PROLINK_IDS_H_



// Message IDs
#define PROLINK_DEVMGMT_MSG_GET_DEVICE_STATUS_REQ       0x17
#define PROLINK_DEVMGMT_MSG_GET_DEVICE_STATUS_RSP       0x18

#define PROLINK_DEVMGMT_MSG_SET_DEVICE_CONFIG_REQ       0x25
#define PROLINK_DEVMGMT_MSG_SET_DEVICE_CONFIG_RSP       0x26

#define PROLINK_DEVMGMT_MSG_GET_DEVICE_CONFIG_REQ       0x27
#define PROLINK_DEVMGMT_MSG_GET_DEVICE_CONFIG_RSP       0x28

#define PROLINK_DEVMGMT_MSG_RESET_DEVICE_CONFIG_REQ     0x29
#define PROLINK_DEVMGMT_MSG_RESET_DEVICE_CONFIG_RSP     0x2A

#define PROLINK_DEVMGMT_MSG_SET_RADIO_STACK_REQ         0x39
#define PROLINK_DEVMGMT_MSG_SET_RADIO_STACK_RSP         0x3A

#define PROLINK_DEVMGMT_MSG_GET_RADIO_STACK_REQ         0x3B
#define PROLINK_DEVMGMT_MSG_GET_RADIO_STACK_RSP         0x3C

//------------------------------------------------------------------------------

/**
 * @brief Radio Stack Mode(only for ProLink)
 */
typedef enum TRadioStack_Mode
{
    RadioStack_LoRaWAN = 0,                                                     /*!< LoRaWAN Stack Mode */
    RadioStack_PROPRIETARY_LR_BASE                                              /*!<  proprietary LR BASE Stack Mode */

} TRadioStack_Mode;


// bit field for Misc.Options in TProLinkDeviceConfig structure
#define PROLINK_DEVICE_CFG_MISC_HCI_PWR_UP_IND_ENABLED       (1 << 3)

typedef struct TProLinkDeviceConfig
{
    /* reserved 1*/
    UINT8   PowerSavingMode;                                                    /*!< PowerSaving; 1 = enable/ on; 0 = disable / off*/
    /* reserved 2*/
    UINT8   MiscOptions;                                                        /*!< misc options field: see PROLINK_DEVICE_CFG_MISC defines */

}TProLinkDeviceConfig;




typedef struct TProLinkDeviceStatus
{
    /*common part*/
    UINT8       Status;                                                         /*!< status flag; indicates if other values are vaild */
    UINT8       SysTickResolution;                                              /*!< systick interval time in ms */
    UINT32      SysTickCounter;                                                 /*!< virtual systick counter value */
    UINT32      RtcTime;                                                        /*!< 32bit encoded current RTC timestamp (@see WIMOD_RTC_* macros)*/
    UINT16      NvmStatus;                                                      /*!< Status of the internal NVM slots */
    UINT16      BatteryStatus;                                                  /*!< current voltage level of power supply in mV */
    UINT16      ExtraStatus;                                                    /*!< extra status bits */

    /*LoRaWAN part*/
    UINT32      LoRaWAN_TxUDataPackets;                                         /*!< number of unreliable radio packets transmitted */
    UINT32      LoRaWAN_TxCDataPackets;                                         /*!< number of reliable radio packets transmitted */
    UINT32      LoRaWAN_TxError;                                                /*!< number of packets not transmitted due to an error */
    UINT32      LoRaWAN_Rx1UDataPackets;                                        /*!< number of unreliable radio packets received in 1st window */
    UINT32      LoRaWAN_Rx1CDataPackets;                                        /*!< number of reliable radio packets received in 1st window */
    UINT32      LoRaWAN_Rx1MicError;                                            /*!< number of radio packets in 1st window with MIC error */
    UINT32      LoRaWAN_Rx2UDataPackets;                                        /*!< number of unreliable radio packets received in 2nd window */
    UINT32      LoRaWAN_Rx2CDataPackets;                                        /*!< number of reliable radio packets received in 2nd window */
    UINT32      LoRaWAN_Rx2MicError;                                            /*!< number of radio packets in 2nd window with MIC error */
    UINT32      LoRaWAN_TxJoin;                                                 /*!< number of join request radio packets transmitted */
    UINT32      LoRaWAN_RxAccept;                                               /*!< number of join accept radio packets received */

    /*proprietary part (LR-BASE)*/
    UINT32      LRBASE_RxPackets;                                               /*!< number of received radio packets with CRC OK */
    UINT32      LRBASE_RxAddressMatch;                                          /*!< number of received radio packets with CRC and Address OK */
    UINT32      LRBASE_RxCRCError;                                              /*!< number of received radio packets with CRC Error */
    UINT32      LRBASE_TxPackets;                                               /*!< number of transmitted radio packets */
    UINT32      LRBASE_TxError;                                                 /*!< number of not transmitted radio packets */
    UINT32      LRBASE_TxMediaBusyEvents;                                       /*!< number of not transmitted packets due to LBT result “media busy” */

} TProLinkDeviceStatus;


#endif /* ARDUINO_SAP_WIMOD_SAP_DEVMGMT_PROLINK_IDS_H_ */
