/*
 * WiMOD_SAP_DEVMGMT_ProLink.h
 *
 *  Created on: Jan 3, 2022
 *      Author: tux
 */

//------------------------------------------------------------------------------
//! @file WiMOD_SAP_DEVMGMT_ProLink.h
//! @ingroup WiMOD_SAP_DEVMGMT_PROLINK
//! <!------------------------------------------------------------------------->
//! @brief Declarations for the DeviceManagement SericeAccessPoint for LoRaWAN ProLink firmware
//! @version 0.1
//! <!------------------------------------------------------------------------->
//!
//!
//!
//! <!--------------------------------------------------------------------------
//! Copyright (c) 2022
//! IMST GmbH
//! Carl-Friedrich Gauss Str. 2-4
//! 47475 Kamp-Lintfort
//! --------------------------------------------------------------------------->
//! @author (FB), IMST
//! <!--------------------------------------------------------------------------
//! Target OS:    none
//! Target CPU:   tbd
//! Compiler:     tbd
//! --------------------------------------------------------------------------->
//! @internal
//! @par Revision History:
//! <PRE>
//!-----------------------------------------------------------------------------
//! Version | Date       | Author | Comment
//!-----------------------------------------------------------------------------
//!
//! </PRE>
//------------------------------------------------------------------------------



#ifndef ARDUINO_SAP_WIMOD_SAP_DEVMGMT_PROLINK_H_
#define ARDUINO_SAP_WIMOD_SAP_DEVMGMT_PROLINK_H_


//------------------------------------------------------------------------------
//
// Section Includes Files
//
//------------------------------------------------------------------------------

#include "WiMOD_SAP_DEVMGMT_Lorawan.h"
#include "WiMOD_SAP_DEVMGMT_ProLink_IDs.h"

//------------------------------------------------------------------------------
//
// Section class
//
//------------------------------------------------------------------------------

/**
 * @brief Implementation for the ServiceAccessPoint DeviceManagement
 */
class WiMOD_SAP_DevMgmt_ProLink : public WiMOD_SAP_DevMgmt_Lorawan
{
public:
    WiMOD_SAP_DevMgmt_ProLink(TWiMODLRHCI* hci, UINT8* buffer, UINT16 bufferSize);
    virtual ~WiMOD_SAP_DevMgmt_ProLink(void);


    virtual TWiMODLRResultCodes SetRadioStack(const TRadioStack_Mode& stackMode, UINT8* statusRsp);
    virtual TWiMODLRResultCodes GetRadioStack(TRadioStack_Mode* stackMode, UINT8* statusRsp);

    virtual TWiMODLRResultCodes SetDeviceConfig(const TProLinkDeviceConfig& config, UINT8* statusRsp);
    virtual TWiMODLRResultCodes GetDeviceConfig(TProLinkDeviceConfig* config, UINT8* statusRsp);

    virtual TWiMODLRResultCodes ResetDeviceConfig(UINT8* statusRsp);

    virtual TWiMODLRResultCodes GetDeviceStatus(TProLinkDeviceStatus* devStatus, UINT8* statusRsp);
    /* deprecated / unsupported by now*/
    virtual TWiMODLRResultCodes GetSystemStatus(TWiMODLR_DevMgmt_SystemStatus* info, UINT8* statusRsp);

protected:
    TWiMODLRResultCodes unsupportedCmd(UINT8* statusRsp);


};



#endif /* ARDUINO_SAP_WIMOD_SAP_DEVMGMT_PROLINK_H_ */
