//------------------------------------------------------------------------------
//! @file WiMOD_SAP_DEVMGMT_Lorwan_IDs.h
//! @ingroup WiMOD_SAP_DEVMGMT_LORAWAN
//! <!------------------------------------------------------------------------->
//! @brief Supporting IDs and definitions for the DeviceManagement ServiceAccessPoint for LoRaWAN EndNode firmware
//! @version 0.1
//! <!------------------------------------------------------------------------->
//!
//!
//!
//! <!--------------------------------------------------------------------------
//! Copyright (c) 2021
//! IMST GmbH
//! Carl-Friedrich Gauss Str. 2
//! 47475 Kamp-Lintfort
//! --------------------------------------------------------------------------->
//! @author (FB), IMST
//! <!--------------------------------------------------------------------------
//! Target OS:    none
//! Target CPU:   tbd
//! Compiler:     tbd
//! --------------------------------------------------------------------------->
//! @internal
//! @par Revision History:
//! <PRE>
//!-----------------------------------------------------------------------------
//! Version | Date       | Author | Comment
//!-----------------------------------------------------------------------------
//!
//! </PRE>
//------------------------------------------------------------------------------


/*
 * THIS IS AN EXAMPLE IMPLEMENTATION ACCORDING THE THE HCI SPEC: V2.1
 * FOR FIRMWARE: LoRaWAN EndeNode
 *
 * SEE FILE: WiMOD_LoRaWAN_EndNode_Firmware_HCI_Spec_V2_1.pdf for detailed information
 */



#ifndef ARDUINO_SAP_WIMOD_SAP_DEVMGMT_LORAWAN_IDS_H_
#define ARDUINO_SAP_WIMOD_SAP_DEVMGMT_LORAWAN_IDS_H_


//------------------------------------------------------------------------------
//
// Section Includes Files
//
//------------------------------------------------------------------------------

#include "WiMOD_SAP_DEVMGMT_IDs.h"


//------------------------------------------------------------------------------
//
// structures
//
//------------------------------------------------------------------------------
/**
 * @brief Structure containing basic information about the WiMOD device
 */
typedef struct TWiMODLR_DevMgmt_DevInfoLoRaWan
{
    UINT8       Status;                                                         /*!< status flag; indicates if other values are vaild */
    UINT8       ModuleType;                                                     /*!< type of WiMOD module */
    UINT32      DevAdr;                                                         /*!< device address; not to be mixed up with the LoRaWAN device address */
    UINT32      DevID;                                                          /*!< the ID of the WiMOD */
} TWiMODLR_DevMgmt_DevInfoLoRaWan;



/**
 * @brief Basic information about system status of the WiMOD
 */
typedef struct TWiMODLR_DevMgmt_SystemStatusLorawan
{
    UINT8       Status;                                                         /*!< status flag; indicates if other values are vaild */
    UINT8       SysTickResolution;                                              /*!< systick interval time in ms */
    UINT32      SysTickCounter;                                                 /*!< virtual systick counter value */
    UINT32      RtcTime;                                                        /*!< 32bit encoded current RTC timestamp (@see WIMOD_RTC_* macros)*/
    UINT16      NvmStatus;                                                      /*!< Status of the internal NVM slots */
    UINT16      BatteryStatus;                                                  /*!< current voltage level of power supply in mV */
    UINT16      ExtraStatus;                                                    /*!< extra status bits */

    UINT32      TxUDataPackets;                                                 /*!< number of unreliable radio packets transmitted */
    UINT32      TxCDataPackets;                                                 /*!< number of reliable radio packets transmitted */
    UINT32      TxError;                                                        /*!< number of packets not transmitted due to an error */
    UINT32      Rx1UDataPackets;                                                /*!< number of unreliable radio packets received in 1st window */
    UINT32      Rx1CDataPackets;                                                /*!< number of reliable radio packets received in 1st window */
    UINT32      Rx1MicError;                                                    /*!< number of radio packets in 1st window with MIC error */
    UINT32      Rx2UDataPackets;                                                /*!< number of unreliable radio packets received in 2nd window */
    UINT32      Rx2CDataPackets;                                                /*!< number of reliable radio packets received in 2nd window */
    UINT32      Rx2MicError;                                                    /*!< number of radio packets in 2nd window with MIC error */
    UINT32      TxJoin;                                                         /*!< number of join request radio packets transmitted */
    UINT32      RxAccept;                                                       /*!< number of join accept radio packets received */

} TWiMODLR_DevMgmt_SystemStatusLorawan;



#endif /* ARDUINO_SAP_WIMOD_SAP_DEVMGMT_LORAWAN_IDS_H_ */
