//------------------------------------------------------------------------------
//! @file WiMOD_SAP_DEVMGMT_LORAWAN.h
//! @ingroup WiMOD_SAP_DEVMGMT_LORAWAN
//! <!------------------------------------------------------------------------->
//! @brief Declarations for the DeviceManagement SericeAccessPoint for LoRaWAN firmware
//! @version 0.1
//! <!------------------------------------------------------------------------->
//!
//!
//!
//! <!--------------------------------------------------------------------------
//! Copyright (c) 2021
//! IMST GmbH
//! Carl-Friedrich Gauss Str. 2-4
//! 47475 Kamp-Lintfort
//! --------------------------------------------------------------------------->
//! @author (FB), IMST
//! <!--------------------------------------------------------------------------
//! Target OS:    none
//! Target CPU:   tbd
//! Compiler:     tbd
//! --------------------------------------------------------------------------->
//! @internal
//! @par Revision History:
//! <PRE>
//!-----------------------------------------------------------------------------
//! Version | Date       | Author | Comment
//!-----------------------------------------------------------------------------
//!
//! </PRE>
//------------------------------------------------------------------------------


#ifndef ARDUINO_SAP_WIMOD_SAP_DEVMGMT_LORAWAN_H_
#define ARDUINO_SAP_WIMOD_SAP_DEVMGMT_LORAWAN_H_


/*
 * THIS IS AN EXAMPLE IMPLEMENTATION ACCORDING THE THE HCI SPEC: V2.1
 * FOR FIRMWARE: LoRaWAN EndNode Firmware
 *
 * SEE FILE: WiMOD_LoRaWAN_EndNode_Firmware_HCI_Spec_V2_1.pdf for detailed information
 *
 */

//------------------------------------------------------------------------------
//
// Section Includes Files
//
//------------------------------------------------------------------------------

#include "WiMOD_SAP_DEVMGMT.h"
#include "WiMOD_SAP_DEVMGMT_Lorawan_IDs.h"
//------------------------------------------------------------------------------
//
// Section class
//
//------------------------------------------------------------------------------

/**
 * @brief Implementation for the ServiceAccessPoint DeviceManagement
 */
class WiMOD_SAP_DevMgmt_Lorawan : public WiMOD_SAP_DevMgmt
{
public:
    WiMOD_SAP_DevMgmt_Lorawan(TWiMODLRHCI* hci, UINT8* buffer, UINT16 bufferSize);
    virtual ~WiMOD_SAP_DevMgmt_Lorawan(void);

    virtual TWiMODLRResultCodes GetDeviceInfo(TWiMODLR_DevMgmt_DevInfo* info, UINT8* statusRsp);
    virtual TWiMODLRResultCodes GetDeviceInfo(TWiMODLR_DevMgmt_DevInfoLoRaWan* info, UINT8* statusRsp);

    virtual TWiMODLRResultCodes GetSystemStatus(TWiMODLR_DevMgmt_SystemStatus* info, UINT8* statusRsp);
    virtual TWiMODLRResultCodes GetSystemStatus(TWiMODLR_DevMgmt_SystemStatusLorawan* info, UINT8* statusRsp);


    virtual TWiMODLRResultCodes GetRadioConfig(TWiMODLR_DevMgmt_RadioConfig* radioCfg, UINT8* statusRsp);
    virtual TWiMODLRResultCodes SetRadioConfig(const TWiMODLR_DevMgmt_RadioConfig* radioCfg, UINT8* statusRsp);
    virtual TWiMODLRResultCodes ResetRadioConfig(UINT8* statusRsp);
    virtual TWiMODLRResultCodes SetRadioMode(const TRadioCfg_RadioMode radioMode, UINT8* statusRsp);
    virtual TWiMODLRResultCodes SetAesKey(const UINT8* key, UINT8* statusRsp);
    virtual TWiMODLRResultCodes GetAesKey(UINT8* key, UINT8* statusRsp);


//    virtual TWiMODLRResultCodes GetRadioConfig(TWiMODLR_DevMgmt_RadioConfig* radioCfg, UINT8* statusRsp);
//    virtual TWiMODLRResultCodes GetRadioConfig(TWiMODLR_DevMgmt_RadioConfigPlus* radioCfg, UINT8* statusRsp);
//
//    virtual TWiMODLRResultCodes SetRadioConfig(const TWiMODLR_DevMgmt_RadioConfig* radioCfg, UINT8* statusRsp);
//    virtual TWiMODLRResultCodes SetRadioConfig(const TWiMODLR_DevMgmt_RadioConfigPlus* radioCfg, UINT8* statusRsp,  UINT8 wrgParamBM[] = NULL);
//
//    virtual TWiMODLRResultCodes GetSystemStatus(TWiMODLR_DevMgmt_SystemStatus* info, UINT8* statusRsp);
//    virtual TWiMODLRResultCodes GetSystemStatus(TWiMODLR_DevMgmt_SystemStatusPlus* info, UINT8* statusRsp);

protected:
    virtual TWiMODLRResultCodes unsupportedCmd(UINT8* statusRsp);

private:
};



#endif /* ARDUINO_SAP_WIMOD_SAP_DEVMGMT_LORAWAN_H_ */






