//------------------------------------------------------------------------------
//! @file WIMOD_SAP_LORAWAN_IDs_AU915.h.h
//! @ingroup WiMOD_SAP_LORAWAN
//! <!------------------------------------------------------------------------->
//! @brief Supporting IDs and definitions for the LoRaWAN ServiceAccessPoint
//! @version 0.1
//! <!------------------------------------------------------------------------->
//!
//!
//!
//! <!--------------------------------------------------------------------------
//! Copyright (c) 2022
//! IMST GmbH
//! Carl-Friedrich Gauss Str. 2-4
//! 47475 Kamp-Lintfort
//! --------------------------------------------------------------------------->
//! @author (FB), IMST
//! <!--------------------------------------------------------------------------
//! Target OS:    none
//! Target CPU:   tbd
//! Compiler:     tbd
//! --------------------------------------------------------------------------->
//! @internal
//! @par Revision History:
//! <PRE>
//!-----------------------------------------------------------------------------
//! Version | Date       | Author | Comment
//!-----------------------------------------------------------------------------
//!
//! </PRE>
//------------------------------------------------------------------------------


/*
 * THIS IS AN EXAMPLE IMPLEMENTATION ACCORDING THE THE HCI SPEC:
 *  ProLink_LoRaWAN_EndNode_Modem_Region_AU915_HCI_Spec.pdf
 *
 * see ProLink_LoRaWAN_EndNode_Modem_Region_AU915_HCI_Spec.pdf
 * for detailed information
 *
 * Reference: RP002-1.0.1 LoRaWAN Regional Parameters document (LoRa Alliance)
 *
 */


#ifndef ARDUINO_SAP_WIMOD_SAP_LORAWAN_IDS_AU915_H_
#define ARDUINO_SAP_WIMOD_SAP_LORAWAN_IDS_AU915_H_

//------------------------------------------------------------------------------
//
// Section Includes Files
//
//------------------------------------------------------------------------------

//! @cond Doxygen_Suppress

#define WIMOD_LORAWAN_AU915



// LoRa Radio Band Index
#define LORAWAN_BAND_AU_915                     41                              /*!<  WiMOD LoRaWAN BAND ID for AU 915 MHz Band */


// LoRa Data Rate Index
#define LORAWAN_DATA_RATE_AU915_LORA_SF12_125KHZ      0                         /*!< LoRaWAN AU DR 0 */
#define LORAWAN_DATA_RATE_AU915_LORA_SF11_125KHZ      1                         /*!< LoRaWAN AU DR 1 */
#define LORAWAN_DATA_RATE_AU915_LORA_SF10_125KHZ      2                         /*!< LoRaWAN AU DR 2 */
#define LORAWAN_DATA_RATE_AU915_LORA_SF9_125KHZ       3                         /*!< LoRaWAN AU DR 3 */
#define LORAWAN_DATA_RATE_AU915_LORA_SF8_125KHZ       4                         /*!< LoRaWAN AU DR 4 */
#define LORAWAN_DATA_RATE_AU915_LORA_SF7_125KHZ       5                         /*!< LoRaWAN AU DR 5 */
#define LORAWAN_DATA_RATE_AU915_LORA_SF8_500KHZ_1     6                         /*!< LoRaWAN AU DR 6 */
#define LORAWAN_DATA_RATE_AU915_LORA_SF12_500KHZ      8                         /*!< LoRaWAN AU DR 8 */
#define LORAWAN_DATA_RATE_AU915_LORA_SF11_500KHZ      9                         /*!< LoRaWAN AU DR 9 */
#define LORAWAN_DATA_RATE_AU915_LORA_SF10_500KHZ      10                        /*!< LoRaWAN AU DR 10 */
#define LORAWAN_DATA_RATE_AU915_LORA_SF9_500KHZ       11                        /*!< LoRaWAN AU DR 11 */
#define LORAWAN_DATA_RATE_AU915_LORA_SF8_500KHZ_2     12                        /*!< LoRaWAN AU DR 12 */
#define LORAWAN_DATA_RATE_AU915_LORA_SF7_500KHZ       13                        /*!< LoRaWAN AU DR 13 */

#define LORAWAN_DATA_RATE_AU915_DR0   LORAWAN_DATA_RATE_AU915_LORA_SF12_125KHZ
#define LORAWAN_DATA_RATE_AU915_DR1   LORAWAN_DATA_RATE_AU915_LORA_SF11_125KHZ
#define LORAWAN_DATA_RATE_AU915_DR2   LORAWAN_DATA_RATE_AU915_LORA_SF10_125KHZ
#define LORAWAN_DATA_RATE_AU915_DR3   LORAWAN_DATA_RATE_AU915_LORA_SF9_125KHZ
#define LORAWAN_DATA_RATE_AU915_DR4   LORAWAN_DATA_RATE_AU915_LORA_SF8_125KHZ
#define LORAWAN_DATA_RATE_AU915_DR5   LORAWAN_DATA_RATE_AU915_LORA_SF7_125KHZ
#define LORAWAN_DATA_RATE_AU915_DR6   LORAWAN_DATA_RATE_AU915_LORA_SF8_500KHZ_1
#define LORAWAN_DATA_RATE_AU915_DR8   LORAWAN_DATA_RATE_AU915_LORA_SF12_500KHZ
#define LORAWAN_DATA_RATE_AU915_DR9   LORAWAN_DATA_RATE_AU915_LORA_SF11_500KHZ
#define LORAWAN_DATA_RATE_AU915_DR10  LORAWAN_DATA_RATE_AU915_LORA_SF10_500KHZ
#define LORAWAN_DATA_RATE_AU915_DR11  LORAWAN_DATA_RATE_AU915_LORA_SF9_500KHZ
#define LORAWAN_DATA_RATE_AU915_DR12  LORAWAN_DATA_RATE_AU915_LORA_SF8_500KHZ_2
#define LORAWAN_DATA_RATE_AU915_DR13  LORAWAN_DATA_RATE_AU915_LORA_SF7_500KHZ


#define IS_LORAWAN_AU915_DATA_RATE(x)                 ( ((x) == LORAWAN_DATA_RATE_AU915_LORA_SF10_125KHZ ) || \
                            ((x) == LORAWAN_DATA_RATE_AU915_LORA_SF9_125KHZ  ) || \
                            ((x) == LORAWAN_DATA_RATE_AU915_LORA_SF8_125KHZ  ) || \
                            ((x) == LORAWAN_DATA_RATE_AU915_LORA_SF7_125KHZ  ) || \
                            ((x) == LORAWAN_DATA_RATE_AU915_LORA_SF8_500KHZ_1) || \
                            ((x) == LORAWAN_DATA_RATE_AU915_LORA_SF12_500KHZ ) || \
                            ((x) == LORAWAN_DATA_RATE_AU915_LORA_SF11_500KHZ ) || \
                            ((x) == LORAWAN_DATA_RATE_AU915_LORA_SF10_500KHZ ) || \
                            ((x) == LORAWAN_DATA_RATE_AU915_LORA_SF9_500KHZ  ) || \
                            ((x) == LORAWAN_DATA_RATE_AU915_LORA_SF8_500KHZ_2) || \
                            ((x) == LORAWAN_DATA_RATE_AU915_LORA_SF7_500KHZ  ) );
//! @endcond


/**
 * @brief LoRa data rate definitions for AU 915 MHz Band
 */
typedef enum TLoRaWANDataRateAU915
{
  LoRaWAN_DataRate_AU915_LoRa_SF12_125KHZ = 0,                                  /*!< LoRa Spreading factor 12 using 125kHz bandwidth */
  LoRaWAN_DataRate_AU915_LoRa_SF11_125KHZ = 1,                                  /*!< LoRa Spreading factor 11 using 125kHz bandwidth */
  LoRaWAN_DataRate_AU915_LoRa_SF10_125KHZ = 2,                                  /*!< LoRa Spreading factor 10 using 125kHz bandwidth */
  LoRaWAN_DataRate_AU915_LoRa_SF9_125KHZ  = 3,                                  /*!< LoRa Spreading factor 9 using 125kHz bandwidth */
  LoRaWAN_DataRate_AU915_LoRa_SF8_125KHZ  = 4,                                  /*!< LoRa Spreading factor 8 using 125kHz bandwidth */
  LoRaWAN_DataRate_AU915_LoRa_SF7_125KHZ  = 5,                                  /*!< LoRa Spreading factor 7 using 125kHz bandwidth */

  LoRaWAN_DataRate_AU915_LoRa_SF8_500KHZ_1  = 6,                                /*!< LoRa Spreading factor 8 using 500kHz bandwidth */
  LoRaWAN_DataRate_AU915_LoRa_SF12_500KHZ = 8,                                  /*!< LoRa Spreading factor 12 using 500kHz bandwidth */
  LoRaWAN_DataRate_AU915_LoRa_SF11_500KHZ = 9,                                  /*!< LoRa Spreading factor 11 using 500kHz bandwidth */
  LoRaWAN_DataRate_AU915_LoRa_SF10_500KHZ = 10,                                 /*!< LoRa Spreading factor 10 using 500kHz bandwidth */
  LoRaWAN_DataRate_AU915_LoRa_SF9_500KHZ  = 11,                                  /*!< LoRa Spreading factor 9 using 500kHz bandwidth */
  LoRaWAN_DataRate_AU915_LoRa_SF8_500KHZ_2  = 12,                               /*!< LoRa Spreading factor 8 using 500kHz bandwidth */
  LoRaWAN_DataRate_AU915_LoRa_SF7_500KHZ  = 13,                                 /*!< LoRa Spreading factor 7 using 500kHz bandwidth */

} TLoRaWANDataRateAU915;



//! @cond Doxygen_Suppress

// LoRa Channel Index ( AU915 )

// uplink
#define LORAWAN_CH_AU_UP_915_2_MHZ                    0                         /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_915_4_MHZ                    1                         /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_915_6_MHZ                    2                         /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_915_8_MHZ                    3                         /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_916_0_MHZ                    4                         /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_916_2_MHZ                    5                         /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_916_4_MHZ                    6                         /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_916_6_MHZ                    7                         /*!< LoRaWAN AU uplink chanel */

#define LORAWAN_CH_AU_UP_916_8_MHZ                    8                         /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_917_0_MHZ                    9                         /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_917_2_MHZ                    10                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_917_4_MHZ                    11                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_917_6_MHZ                    12                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_917_8_MHZ                    13                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_918_0_MHZ                    14                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_918_2_MHZ                    15                        /*!< LoRaWAN AU uplink chanel */

#define LORAWAN_CH_AU_UP_918_4_MHZ                    16                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_918_6_MHZ                    17                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_918_8_MHZ                    18                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_919_0_MHZ                    19                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_919_2_MHZ                    20                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_919_4_MHZ                    21                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_919_6_MHZ                    22                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_919_8_MHZ                    23                        /*!< LoRaWAN AU uplink chanel */

#define LORAWAN_CH_AU_UP_920_0_MHZ                    24                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_920_2_MHZ                    25                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_920_4_MHZ                    26                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_920_6_MHZ                    27                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_920_8_MHZ                    28                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_921_0_MHZ                    29                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_921_2_MHZ                    30                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_921_4_MHZ                    31                        /*!< LoRaWAN AU uplink chanel */

#define LORAWAN_CH_AU_UP_921_6_MHZ                    32                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_921_8_MHZ                    33                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_922_0_MHZ                    34                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_922_2_MHZ                    35                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_922_4_MHZ                    36                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_922_6_MHZ                    37                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_922_8_MHZ                    38                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_923_0_MHZ                    39                        /*!< LoRaWAN AU uplink chanel */

#define LORAWAN_CH_AU_UP_923_2_MHZ                    40                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_923_4_MHZ                    41                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_923_6_MHZ                    42                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_923_8_MHZ                    43                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_924_0_MHZ                    44                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_924_2_MHZ                    45                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_924_4_MHZ                    46                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_924_6_MHZ                    47                        /*!< LoRaWAN AU uplink chanel */

#define LORAWAN_CH_AU_UP_924_8_MHZ                    48                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_9225_0_MHZ                    49                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_925_2_MHZ                    50                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_925_4_MHZ                    51                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_925_6_MHZ                    52                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_925_8_MHZ                    53                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_926_0_MHZ                    54                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_926_2_MHZ                    55                        /*!< LoRaWAN AU uplink chanel */

#define LORAWAN_CH_AU_UP_926_4_MHZ                    56                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_926_6_MHZ                    57                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_926_8_MHZ                    58                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_927_0_MHZ                    59                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_927_2_MHZ                    60                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_927_4_MHZ                    61                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_927_6_MHZ                    62                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_927_8_MHZ                    63                        /*!< LoRaWAN AU uplink chanel */

#define LORAWAN_CH_AU_UP_915_9_MHZ                    64                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_917_5_MHZ                    65                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_919_1_MHZ                    66                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_920_7_MHZ                    67                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_922_3_MHZ                    68                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_923_9_MHZ                    69                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_925_5_MHZ                    70                        /*!< LoRaWAN AU uplink chanel */
#define LORAWAN_CH_AU_UP_927_1_MHZ                    71                        /*!< LoRaWAN AU uplink chanel */



//downlink
#define LORAWAN_CH_AU_DN_923_3_MHZ                    0                         /*!< LoRaWAN AU downlink chanel */
#define LORAWAN_CH_AU_DN_923_9_MHZ                    1
#define LORAWAN_CH_AU_DN_924_5_MHZ                    2
#define LORAWAN_CH_AU_DN_925_1_MHZ                    3
#define LORAWAN_CH_AU_DN_925_7_MHZ                    4
#define LORAWAN_CH_AU_DN_926_3_MHZ                    5
#define LORAWAN_CH_AU_DN_926_9_MHZ                    6
#define LORAWAN_CH_AU_DN_927_5_MHZ                    7

#define LORAWAN_CH_AU_DN_923_3_MHZ_2                  8
#define LORAWAN_CH_AU_DN_923_9_MHZ_2                  9
#define LORAWAN_CH_AU_DN_924_5_MHZ_2                  10
#define LORAWAN_CH_AU_DN_925_1_MHZ_2                  11
#define LORAWAN_CH_AU_DN_925_7_MHZ_2                  12
#define LORAWAN_CH_AU_DN_926_3_MHZ_2                  13
#define LORAWAN_CH_AU_DN_926_9_MHZ_2                  14
#define LORAWAN_CH_AU_DN_927_5_MHZ_2                  15

#define LORAWAN_CH_AU_DN_923_3_MHZ_3                  16
#define LORAWAN_CH_AU_DN_923_9_MHZ_3                  17
#define LORAWAN_CH_AU_DN_924_5_MHZ_3                  18
#define LORAWAN_CH_AU_DN_925_1_MHZ_3                  19
#define LORAWAN_CH_AU_DN_925_7_MHZ_3                  20
#define LORAWAN_CH_AU_DN_926_3_MHZ_3                  21
#define LORAWAN_CH_AU_DN_926_9_MHZ_3                  22
#define LORAWAN_CH_AU_DN_927_5_MHZ_3                  23

#define LORAWAN_CH_AU_DN_923_3_MHZ_4                  24
#define LORAWAN_CH_AU_DN_923_9_MHZ_4                  25
#define LORAWAN_CH_AU_DN_924_5_MHZ_4                  26
#define LORAWAN_CH_AU_DN_925_1_MHZ_4                  27
#define LORAWAN_CH_AU_DN_925_7_MHZ_4                  28
#define LORAWAN_CH_AU_DN_926_3_MHZ_4                  29
#define LORAWAN_CH_AU_DN_926_9_MHZ_4                  30
#define LORAWAN_CH_AU_DN_927_5_MHZ_4                  31

#define LORAWAN_CH_AU_DN_923_3_MHZ_5                  32
#define LORAWAN_CH_AU_DN_923_9_MHZ_5                  33
#define LORAWAN_CH_AU_DN_924_5_MHZ_5                  34
#define LORAWAN_CH_AU_DN_925_1_MHZ_5                  35
#define LORAWAN_CH_AU_DN_925_7_MHZ_5                  36
#define LORAWAN_CH_AU_DN_926_3_MHZ_5                  37
#define LORAWAN_CH_AU_DN_926_9_MHZ_5                  38
#define LORAWAN_CH_AU_DN_927_5_MHZ_5                  39

#define LORAWAN_CH_AU_DN_923_3_MHZ_6                  40
#define LORAWAN_CH_AU_DN_923_9_MHZ_6                  41
#define LORAWAN_CH_AU_DN_924_5_MHZ_6                  42
#define LORAWAN_CH_AU_DN_925_1_MHZ_6                  43
#define LORAWAN_CH_AU_DN_925_7_MHZ_6                  44
#define LORAWAN_CH_AU_DN_926_3_MHZ_6                  45
#define LORAWAN_CH_AU_DN_926_9_MHZ_6                  46
#define LORAWAN_CH_AU_DN_927_5_MHZ_6                  47

#define LORAWAN_CH_AU_DN_923_3_MHZ_7                  48
#define LORAWAN_CH_AU_DN_923_9_MHZ_7                  49
#define LORAWAN_CH_AU_DN_924_5_MHZ_7                  50
#define LORAWAN_CH_AU_DN_925_1_MHZ_7                  51
#define LORAWAN_CH_AU_DN_925_7_MHZ_7                  52
#define LORAWAN_CH_AU_DN_926_3_MHZ_7                  53
#define LORAWAN_CH_AU_DN_926_9_MHZ_7                  54
#define LORAWAN_CH_AU_DN_927_5_MHZ_7                  55

#define LORAWAN_CH_AU_DN_923_3_MHZ_8                  56
#define LORAWAN_CH_AU_DN_923_9_MHZ_8                  57
#define LORAWAN_CH_AU_DN_924_5_MHZ_8                  58
#define LORAWAN_CH_AU_DN_925_1_MHZ_8                  59
#define LORAWAN_CH_AU_DN_925_7_MHZ_8                  60
#define LORAWAN_CH_AU_DN_926_3_MHZ_8                  61
#define LORAWAN_CH_AU_DN_926_9_MHZ_8                  62
#define LORAWAN_CH_AU_DN_927_5_MHZ_8                  63

#define LORAWAN_CH_AU_DN_923_3_MHZ_9                  64
#define LORAWAN_CH_AU_DN_923_9_MHZ_9                  65
#define LORAWAN_CH_AU_DN_924_5_MHZ_9                  66
#define LORAWAN_CH_AU_DN_925_1_MHZ_9                  67
#define LORAWAN_CH_AU_DN_925_7_MHZ_9                  68
#define LORAWAN_CH_AU_DN_926_3_MHZ_9                  69
#define LORAWAN_CH_AU_DN_926_9_MHZ_9                  70
#define LORAWAN_CH_AU_DN_927_5_MHZ_9                  71

#define LORAWAN_CH_AU_DN_923_3_MHZ_10                 128



#define IS_LORAWAN_CH_AU915_UP(x)               ( ((x) >= LORAWAN_CH_AU_UP_915_2_MHZ) && \
                                                  ((x) <= LORAWAN_CH_AU_UP_927_1_MHZ) )


#define IS_LORAWAN_CH_AU915_DN(x)                 ( (((x) >= LORAWAN_CH_AU_DN_923_3_MHZ) && \
                          ((x) <= LORAWAN_CH_AU_DN_927_5_MHZ_9) ) || \
                          ((x) == LORAWAN_CH_AU_DN_923_3_MHZ_10) )


//! @endcond

/**
 * @brief Channel definition for AU 915MHz Band uplink
 */
typedef enum TLoRaWAN_Channel_AU_UP
{
  LoRaWAN_Channel_AU_UP_915_2_MHZ = 0,                                          /*!< carrier frequency of 915.2 MHz for uplink */
  LoRaWAN_Channel_AU_UP_915_4_MHZ = 1,                                          /*!< carrier frequency of 915.4 MHz for uplink */
  LoRaWAN_Channel_AU_UP_915_6_MHZ = 2,                                          /*!< carrier frequency of 915.6 MHz for uplink */
  LoRaWAN_Channel_AU_UP_915_8_MHZ = 3,                                          /*!< carrier frequency of 915.8 MHz for uplink */
  LoRaWAN_Channel_AU_UP_916_0_MHZ = 4,                                          /*!< carrier frequency of 916.0 MHz for uplink */
  LoRaWAN_Channel_AU_UP_916_2_MHZ = 5,                                          /*!< carrier frequency of 916.2 MHz for uplink */
  LoRaWAN_Channel_AU_UP_916_4_MHZ = 6,                                          /*!< carrier frequency of 916.4 MHz for uplink */
  LoRaWAN_Channel_AU_UP_916_6_MHZ = 7,                                          /*!< carrier frequency of 916.6 MHz for uplink */

  LoRaWAN_Channel_AU_UP_916_8_MHZ = 8,                                          /*!< carrier frequency of 916.8 MHz for uplink */
  LoRaWAN_Channel_AU_UP_917_0_MHZ = 9,                                          /*!< carrier frequency of 917.0 MHz for uplink */
  LoRaWAN_Channel_AU_UP_917_2_MHZ = 10,                                         /*!< carrier frequency of 917.2 MHz for uplink */
  LoRaWAN_Channel_AU_UP_917_4_MHZ = 11,                                         /*!< carrier frequency of 917.4 MHz for uplink */
  LoRaWAN_Channel_AU_UP_917_6_MHZ = 12,                                         /*!< carrier frequency of 917.6 MHz for uplink */
  LoRaWAN_Channel_AU_UP_917_8_MHZ = 13,                                         /*!< carrier frequency of 917.8 MHz for uplink */
  LoRaWAN_Channel_AU_UP_918_0_MHZ = 14,                                         /*!< carrier frequency of 918.0 MHz for uplink */
  LoRaWAN_Channel_AU_UP_918_2_MHZ = 15,                                         /*!< carrier frequency of 918.2 MHz for uplink */

  LoRaWAN_Channel_AU_UP_918_4_MHZ = 16,                                         /*!< carrier frequency of 918.4 MHz for uplink */
  LoRaWAN_Channel_AU_UP_918_6_MHZ = 17,                                         /*!< carrier frequency of 918.6 MHz for uplink */
  LoRaWAN_Channel_AU_UP_918_8_MHZ = 18,                                         /*!< carrier frequency of 918.8 MHz for uplink */
  LoRaWAN_Channel_AU_UP_919_0_MHZ = 19,                                         /*!< carrier frequency of 919.0 MHz for uplink */
  LoRaWAN_Channel_AU_UP_919_2_MHZ = 20,                                         /*!< carrier frequency of 919.2 MHz for uplink */
  LoRaWAN_Channel_AU_UP_919_4_MHZ = 21,                                         /*!< carrier frequency of 919.4 MHz for uplink */
  LoRaWAN_Channel_AU_UP_919_6_MHZ = 22,                                         /*!< carrier frequency of 919.6 MHz for uplink */
  LoRaWAN_Channel_AU_UP_919_8_MHZ = 23,                                         /*!< carrier frequency of 919.8 MHz for uplink */

  LoRaWAN_Channel_AU_UP_920_0_MHZ = 24,                                         /*!< carrier frequency of 920.0 MHz for uplink */
  LoRaWAN_Channel_AU_UP_920_2_MHZ = 25,                                         /*!< carrier frequency of 920.2 MHz for uplink */
  LoRaWAN_Channel_AU_UP_920_4_MHZ = 26,                                         /*!< carrier frequency of 920.4 MHz for uplink */
  LoRaWAN_Channel_AU_UP_920_6_MHZ = 27,                                         /*!< carrier frequency of 920.6 MHz for uplink */
  LoRaWAN_Channel_AU_UP_920_8_MHZ = 28,                                         /*!< carrier frequency of 920.8 MHz for uplink */
  LoRaWAN_Channel_AU_UP_921_0_MHZ = 29,                                         /*!< carrier frequency of 921.0 MHz for uplink */
  LoRaWAN_Channel_AU_UP_921_2_MHZ = 30,                                         /*!< carrier frequency of 921.2 MHz for uplink */
  LoRaWAN_Channel_AU_UP_921_4_MHZ = 31,                                         /*!< carrier frequency of 921.4 MHz for uplink */

  LoRaWAN_Channel_AU_UP_921_6_MHZ = 32,                                         /*!< carrier frequency of 921.6 MHz for uplink */
  LoRaWAN_Channel_AU_UP_921_8_MHZ = 33,                                         /*!< carrier frequency of 921.8 MHz for uplink */
  LoRaWAN_Channel_AU_UP_922_0_MHZ = 34,                                         /*!< carrier frequency of 922.0 MHz for uplink */
  LoRaWAN_Channel_AU_UP_922_2_MHZ = 35,                                         /*!< carrier frequency of 922.2 MHz for uplink */
  LoRaWAN_Channel_AU_UP_922_4_MHZ = 36,                                         /*!< carrier frequency of 922.4 MHz for uplink */
  LoRaWAN_Channel_AU_UP_922_6_MHZ = 37,                                         /*!< carrier frequency of 922.6 MHz for uplink */
  LoRaWAN_Channel_AU_UP_922_8_MHZ = 38,                                         /*!< carrier frequency of 922.8 MHz for uplink */
  LoRaWAN_Channel_AU_UP_923_0_MHZ = 39,                                         /*!< carrier frequency of 923.0 MHz for uplink */

  LoRaWAN_Channel_AU_UP_923_2_MHZ = 40,                                         /*!< carrier frequency of 923.2 MHz for uplink */
  LoRaWAN_Channel_AU_UP_923_4_MHZ = 41,                                         /*!< carrier frequency of 923.4 MHz for uplink */
  LoRaWAN_Channel_AU_UP_923_6_MHZ = 42,                                         /*!< carrier frequency of 923.6 MHz for uplink */
  LoRaWAN_Channel_AU_UP_923_8_MHZ = 43,                                         /*!< carrier frequency of 923.8 MHz for uplink */
  LoRaWAN_Channel_AU_UP_924_0_MHZ = 44,                                         /*!< carrier frequency of 924.0 MHz for uplink */
  LoRaWAN_Channel_AU_UP_924_2_MHZ = 45,                                         /*!< carrier frequency of 924.2 MHz for uplink */
  LoRaWAN_Channel_AU_UP_924_4_MHZ = 46,                                         /*!< carrier frequency of 924.4 MHz for uplink */
  LoRaWAN_Channel_AU_UP_924_6_MHZ = 47,                                         /*!< carrier frequency of 924.6 MHz for uplink */

  LoRaWAN_Channel_AU_UP_924_8_MHZ = 48,                                         /*!< carrier frequency of 924.8 MHz for uplink */
  LoRaWAN_Channel_AU_UP_925_0_MHZ = 49,                                         /*!< carrier frequency of 925.0 MHz for uplink */
  LoRaWAN_Channel_AU_UP_925_2_MHZ = 50,                                         /*!< carrier frequency of 925.2 MHz for uplink */
  LoRaWAN_Channel_AU_UP_925_4_MHZ = 51,                                         /*!< carrier frequency of 925.4 MHz for uplink */
  LoRaWAN_Channel_AU_UP_925_6_MHZ = 52,                                         /*!< carrier frequency of 925.6 MHz for uplink */
  LoRaWAN_Channel_AU_UP_925_8_MHZ = 53,                                         /*!< carrier frequency of 925.8 MHz for uplink */
  LoRaWAN_Channel_AU_UP_926_0_MHZ = 54,                                         /*!< carrier frequency of 926.0 MHz for uplink */
  LoRaWAN_Channel_AU_UP_926_2_MHZ = 55,                                         /*!< carrier frequency of 926.2 MHz for uplink */

  LoRaWAN_Channel_AU_UP_926_4_MHZ = 56,                                         /*!< carrier frequency of 926.4 MHz for uplink */
  LoRaWAN_Channel_AU_UP_926_6_MHZ = 57,                                         /*!< carrier frequency of 926.6 MHz for uplink */
  LoRaWAN_Channel_AU_UP_926_8_MHZ = 58,                                         /*!< carrier frequency of 926.8 MHz for uplink */
  LoRaWAN_Channel_AU_UP_927_0_MHZ = 59,                                         /*!< carrier frequency of 927.0 MHz for uplink */
  LoRaWAN_Channel_AU_UP_927_2_MHZ = 60,                                         /*!< carrier frequency of 927.2 MHz for uplink */
  LoRaWAN_Channel_AU_UP_927_4_MHZ = 61,                                         /*!< carrier frequency of 927.4 MHz for uplink */
  LoRaWAN_Channel_AU_UP_927_6_MHZ = 62,                                         /*!< carrier frequency of 927.6 MHz for uplink */
  LoRaWAN_Channel_AU_UP_927_8_MHZ = 63,                                         /*!< carrier frequency of 927.8 MHz for uplink */

  LoRaWAN_Channel_AU_UP_915_9_MHZ = 64,                                         /*!< carrier frequency of 915.9 MHz for uplink */
  LoRaWAN_Channel_AU_UP_917_5_MHZ = 65,                                         /*!< carrier frequency of 917.5 MHz for uplink */
  LoRaWAN_Channel_AU_UP_919_1_MHZ = 66,                                         /*!< carrier frequency of 919.1 MHz for uplink */
  LoRaWAN_Channel_AU_UP_920_7_MHZ = 67,                                         /*!< carrier frequency of 920.7 MHz for uplink */
  LoRaWAN_Channel_AU_UP_922_3_MHZ = 68,                                         /*!< carrier frequency of 922.3 MHz for uplink */
  LoRaWAN_Channel_AU_UP_923_9_MHZ = 69,                                         /*!< carrier frequency of 923.9 MHz for uplink */
  LoRaWAN_Channel_AU_UP_925_5_MHZ = 70,                                         /*!< carrier frequency of 925.5 MHz for uplink */
  LoRaWAN_Channel_AU_UP_927_1_MHZ = 71,                                         /*!< carrier frequency of 927.1 MHz for uplink */
} TLoRaWAN_Channel_AU_UP;



/**
 * @brief Channel definition for AU 915MHz Band downlink
 */
typedef enum TLoRaWAN_Channel_AU_DN
{
  LoRaWAN_Channel_AU_DN_923_3_MHz = 0,                                          /*!< carrier frequency of 923.3 MHz for downlink */
  LoRaWAN_Channel_AU_DN_923_9_MHz = 1,                                          /*!< carrier frequency of 923.9 MHz for downlink */
  LoRaWAN_Channel_AU_DN_924_5_MHz = 2,                                          /*!< carrier frequency of 924.5 MHz for downlink */
  LoRaWAN_Channel_AU_DN_925_1_MHz = 3,                                          /*!< carrier frequency of 925.1 MHz for downlink */
  LoRaWAN_Channel_AU_DN_925_7_MHz = 4,                                          /*!< carrier frequency of 925.7 MHz for downlink */
  LoRaWAN_Channel_AU_DN_926_3_MHz = 5,                                          /*!< carrier frequency of 926.3 MHz for downlink */
  LoRaWAN_Channel_AU_DN_926_9_MHz = 6,                                          /*!< carrier frequency of 926.9 MHz for downlink */
  LoRaWAN_Channel_AU_DN_927_5_MHz = 7,                                          /*!< carrier frequency of 927.5 MHz for downlink */

  LoRaWAN_Channel_AU_DN_923_3_MHz_2 = 8,                                        /*!< carrier frequency of 923.3 MHz for downlink */
  LoRaWAN_Channel_AU_DN_923_9_MHz_2 = 9,                                        /*!< carrier frequency of 923.9 MHz for downlink */
  LoRaWAN_Channel_AU_DN_924_5_MHz_2 = 10,                                       /*!< carrier frequency of 924.5 MHz for downlink */
  LoRaWAN_Channel_AU_DN_925_1_MHz_2 = 11,                                       /*!< carrier frequency of 925.1 MHz for downlink */
  LoRaWAN_Channel_AU_DN_925_7_MHz_2 = 12,                                       /*!< carrier frequency of 925.7 MHz for downlink */
  LoRaWAN_Channel_AU_DN_926_3_MHz_2 = 13,                                       /*!< carrier frequency of 926.3 MHz for downlink */
  LoRaWAN_Channel_AU_DN_926_9_MHz_2 = 14,                                       /*!< carrier frequency of 926.9 MHz for downlink */
  LoRaWAN_Channel_AU_DN_927_5_MHz_2 = 15,                                       /*!< carrier frequency of 927.5 MHz for downlink */

  LoRaWAN_Channel_AU_DN_923_3_MHz_3 = 16,                                       /*!< carrier frequency of 923.3 MHz for downlink */
  LoRaWAN_Channel_AU_DN_923_9_MHz_3 = 17,                                       /*!< carrier frequency of 923.9 MHz for downlink */
  LoRaWAN_Channel_AU_DN_924_5_MHz_3 = 18,                                       /*!< carrier frequency of 924.5 MHz for downlink */
  LoRaWAN_Channel_AU_DN_925_1_MHz_3 = 19,                                       /*!< carrier frequency of 925.1 MHz for downlink */
  LoRaWAN_Channel_AU_DN_925_7_MHz_3 = 20,                                       /*!< carrier frequency of 925.7 MHz for downlink */
  LoRaWAN_Channel_AU_DN_926_3_MHz_3 = 21,                                       /*!< carrier frequency of 926.3 MHz for downlink */
  LoRaWAN_Channel_AU_DN_926_9_MHz_3 = 22,                                       /*!< carrier frequency of 926.9 MHz for downlink */
  LoRaWAN_Channel_AU_DN_927_5_MHz_3 = 23,                                       /*!< carrier frequency of 927.5 MHz for downlink */

  LoRaWAN_Channel_AU_DN_923_3_MHz_4 = 24,                                       /*!< carrier frequency of 923.3 MHz for downlink */
  LoRaWAN_Channel_AU_DN_923_9_MHz_4 = 25,                                       /*!< carrier frequency of 923.9 MHz for downlink */
  LoRaWAN_Channel_AU_DN_924_5_MHz_4 = 26,                                       /*!< carrier frequency of 924.5 MHz for downlink */
  LoRaWAN_Channel_AU_DN_925_1_MHz_4 = 27,                                       /*!< carrier frequency of 925.1 MHz for downlink */
  LoRaWAN_Channel_AU_DN_925_7_MHz_4 = 28,                                       /*!< carrier frequency of 925.7 MHz for downlink */
  LoRaWAN_Channel_AU_DN_926_3_MHz_4 = 29,                                       /*!< carrier frequency of 926.3 MHz for downlink */
  LoRaWAN_Channel_AU_DN_926_9_MHz_4 = 30,                                       /*!< carrier frequency of 926.9 MHz for downlink */
  LoRaWAN_Channel_AU_DN_927_5_MHz_4 = 31,                                       /*!< carrier frequency of 927.5 MHz for downlink */

  LoRaWAN_Channel_AU_DN_923_3_MHz_5 = 32,                                       /*!< carrier frequency of 923.3 MHz for downlink */
  LoRaWAN_Channel_AU_DN_923_9_MHz_5 = 33,                                       /*!< carrier frequency of 923.9 MHz for downlink */
  LoRaWAN_Channel_AU_DN_924_5_MHz_5 = 34,                                       /*!< carrier frequency of 924.5 MHz for downlink */
  LoRaWAN_Channel_AU_DN_925_1_MHz_5 = 35,                                       /*!< carrier frequency of 925.1 MHz for downlink */
  LoRaWAN_Channel_AU_DN_925_7_MHz_5 = 36,                                       /*!< carrier frequency of 925.7 MHz for downlink */
  LoRaWAN_Channel_AU_DN_926_3_MHz_5 = 37,                                       /*!< carrier frequency of 926.3 MHz for downlink */
  LoRaWAN_Channel_AU_DN_926_9_MHz_5 = 38,                                       /*!< carrier frequency of 926.9 MHz for downlink */
  LoRaWAN_Channel_AU_DN_927_5_MHz_5 = 39,                                       /*!< carrier frequency of 927.5 MHz for downlink */

  LoRaWAN_Channel_AU_DN_923_3_MHz_6 = 40,                                       /*!< carrier frequency of 923.3 MHz for downlink */
  LoRaWAN_Channel_AU_DN_923_9_MHz_6 = 41,                                       /*!< carrier frequency of 923.9 MHz for downlink */
  LoRaWAN_Channel_AU_DN_924_5_MHz_6 = 42,                                       /*!< carrier frequency of 924.5 MHz for downlink */
  LoRaWAN_Channel_AU_DN_925_1_MHz_6 = 43,                                       /*!< carrier frequency of 925.1 MHz for downlink */
  LoRaWAN_Channel_AU_DN_925_7_MHz_6 = 44,                                       /*!< carrier frequency of 925.7 MHz for downlink */
  LoRaWAN_Channel_AU_DN_926_3_MHz_6 = 45,                                       /*!< carrier frequency of 926.3 MHz for downlink */
  LoRaWAN_Channel_AU_DN_926_9_MHz_6 = 46,                                       /*!< carrier frequency of 926.9 MHz for downlink */
  LoRaWAN_Channel_AU_DN_927_5_MHz_6 = 47,                                       /*!< carrier frequency of 927.5 MHz for downlink */

  LoRaWAN_Channel_AU_DN_923_3_MHz_7 = 48,                                       /*!< carrier frequency of 923.3 MHz for downlink */
  LoRaWAN_Channel_AU_DN_923_9_MHz_7 = 49,                                       /*!< carrier frequency of 923.9 MHz for downlink */
  LoRaWAN_Channel_AU_DN_924_5_MHz_7 = 50,                                       /*!< carrier frequency of 924.5 MHz for downlink */
  LoRaWAN_Channel_AU_DN_925_1_MHz_7 = 51,                                       /*!< carrier frequency of 925.1 MHz for downlink */
  LoRaWAN_Channel_AU_DN_925_7_MHz_7 = 52,                                       /*!< carrier frequency of 925.7 MHz for downlink */
  LoRaWAN_Channel_AU_DN_926_3_MHz_7 = 53,                                       /*!< carrier frequency of 926.3 MHz for downlink */
  LoRaWAN_Channel_AU_DN_926_9_MHz_7 = 54,                                       /*!< carrier frequency of 926.9 MHz for downlink */
  LoRaWAN_Channel_AU_DN_927_5_MHz_7 = 55,                                       /*!< carrier frequency of 927.5 MHz for downlink */

  LoRaWAN_Channel_AU_DN_923_3_MHz_8 = 56,                                       /*!< carrier frequency of 923.3 MHz for downlink */
  LoRaWAN_Channel_AU_DN_923_9_MHz_8 = 57,                                       /*!< carrier frequency of 923.9 MHz for downlink */
  LoRaWAN_Channel_AU_DN_924_5_MHz_8 = 58,                                       /*!< carrier frequency of 924.5 MHz for downlink */
  LoRaWAN_Channel_AU_DN_925_1_MHz_8 = 59,                                       /*!< carrier frequency of 925.1 MHz for downlink */
  LoRaWAN_Channel_AU_DN_925_7_MHz_8 = 60,                                       /*!< carrier frequency of 925.7 MHz for downlink */
  LoRaWAN_Channel_AU_DN_926_3_MHz_8 = 61,                                       /*!< carrier frequency of 926.3 MHz for downlink */
  LoRaWAN_Channel_AU_DN_926_9_MHz_8 = 62,                                       /*!< carrier frequency of 926.9 MHz for downlink */
  LoRaWAN_Channel_AU_DN_927_5_MHz_8 = 63,                                       /*!< carrier frequency of 927.5 MHz for downlink */

  LoRaWAN_Channel_AU_DN_923_3_MHz_9 = 64,                                       /*!< carrier frequency of 923.3 MHz for downlink */
  LoRaWAN_Channel_AU_DN_923_9_MHz_9 = 65,                                       /*!< carrier frequency of 923.9 MHz for downlink */
  LoRaWAN_Channel_AU_DN_924_5_MHz_9 = 66,                                       /*!< carrier frequency of 924.5 MHz for downlink */
  LoRaWAN_Channel_AU_DN_925_1_MHz_9 = 67,                                       /*!< carrier frequency of 925.1 MHz for downlink */
  LoRaWAN_Channel_AU_DN_925_7_MHz_9 = 68,                                       /*!< carrier frequency of 925.7 MHz for downlink */
  LoRaWAN_Channel_AU_DN_926_3_MHz_9 = 69,                                       /*!< carrier frequency of 926.3 MHz for downlink */
  LoRaWAN_Channel_AU_DN_926_9_MHz_9 = 70,                                       /*!< carrier frequency of 926.9 MHz for downlink */
  LoRaWAN_Channel_AU_DN_927_5_MHz_9 = 71,                                       /*!< carrier frequency of 927.5 MHz for downlink */

  LoRaWAN_Channel_AU_DN_923_3_MHz_10 = 128,                                     /*!< carrier frequency of 923.3 MHz for downlink */
} TLoRaWAN_Channel_AU_DN;


#endif /* ARDUINO_SAP_WIMOD_SAP_LORAWAN_IDS_AU915_H_ */
